//-- To create a new project go to File::New::Project
//-- In the left column, select Visual C++::CLR
//-- In the right side, select the CLR Empty Project and select the name and
//-- location for your project

//-- There is NO need for any headers
//-- You only need to reference the API file that we have already provided
//-- To reference the API file, select the project in the Solution Explorer
//-- and then go to Project::Properties
//-- In the left column, select Common Properties::References
//-- In the right column, click the Add New Reference button
//-- In the new box, go to the Browse tab and navigate to the DSM202 program
//-- folder and select the Euvis_Module_V1p2.DLL file

using	namespace	MOL;
using	namespace	MOL::DSM2;
using	namespace	System::Threading;

//-- If you want to use traditional unmanaged codes you can also include the header
//-- Unmanaged Header
#include <stdio.h>
	
int	main( )
{
	//---- Object instantiation
	DSM_Group_API	dsm202_group;
	DSMX2			dsm202;

	//---- Check if there is at least one DSM202 module connected
	if( dsm202_group.number == 0 )
	{
		printf( "No Module Exists!!\n" );
		return 1;
	}

	//---- Get the module series number
	int	SeriesNumber = dsm202_group.get_sn(0);
	printf( "Found Device with SN: %d\n\n", SeriesNumber );

    //---- Initialize the DSM202
	//---- If you use multiple modules of the same type
	//---- you need to qualify the module_series number for the each module
	dsm202.ini( SeriesNumber );

	//---- Check if the module_id_number is DSM202
	//---- module_id_number is used to identify the selected module 
	//---- in case multiple modules of different types, like AWG's or DSM303, coexist
	if( dsm202.module_id_number != (unsigned)MODULE_ID::DSM202 )
	{
		printf( "Got ID number: %d\n", dsm202.module_id_number );
		printf( "No DSM Module Exists!!\n" );
		return 1;
	}
		
	//---------------------------------------------------------------------------
	//---- Waveform Parameters
	//---------------------------------------------------------------------------
	
	//---- Setup the waveform parameters
	printf( "Setting Waveform Parameters\n" );
	dsm202.abort				= true;
	dsm202.chirp1				= 0x1000000;	// defines chirp start freq
	dsm202.chirp2				= 0x10000000;	// defines chirp stop freq
	dsm202.chirp3				= 0x1000000;	// defines chirp step freq
	
	//---- Marker
	printf( "Setting Markers\n" );
	dsm202.marker_start			= 0x0;			// defines marker start
	dsm202.marker_width			= 0x4;			// defines marker width
	
	//---- Check Marker Filter Option
	printf( "Marker Filter On: %d\n\n", dsm202.is_option_marker_filter );

	//---------------------------------------------------------------------------
	//---- Waveform Start
	//---------------------------------------------------------------------------

	//---- Normal Waveform in Free Run Mode
	printf( "Free Run Normal Waveform\n" );
	dsm202.triangle_chirp		= false;		// normal waveform
	dsm202.marker_filter_count1	= 0;			// define marker filter count
	dsm202.free_run				= true;			// set high to start waveform
	Thread::Sleep( 8000 );						// program pauses for 8 sec
	dsm202.abort				= true;			// stops waveform

	//---- Triangle Waveform in Free Run Mode
	printf( "Free Run Triangle Waveform\n" );
	dsm202.triangle_chirp		= true;			// triangle waveform
	dsm202.marker_filter_count1	= 0;
	dsm202.free_run				= true;
	Thread::Sleep( 8000 );
	dsm202.abort				= true;

	//---- Normal Waveform in Free Run Mode with Marker Filter
	printf( "Free Run Normal Waveform with Marker Filter = 2\n\n" );
	dsm202.triangle_chirp		= false;
	dsm202.marker_filter_count1	= 2;
	dsm202.free_run				= true;
	Thread::Sleep( 8000 );
	dsm202.abort				= true;
	
	
	//---- Normal Waveform in Triggered Mode
	printf( "Triggered Normal Waveform\n" );
	dsm202.triangle_chirp		= false;
	dsm202.marker_filter_count1	= 0;
	dsm202.arm					= true;			// set high to arm board
	Thread::Sleep( 8000 );
	dsm202.abort				= true;

	//---- Triangle Waveform in Triggered Mode
	printf( "Triggered Triangle Waveform\n" );
	dsm202.triangle_chirp		= true;
	dsm202.marker_filter_count1	= 0;
	dsm202.arm					= true;
	Thread::Sleep( 8000 );
	dsm202.abort				= true;

	//---- Triangle Waveform in Triggered Mode with Marker Filter
	printf( "Triggered Triangle Waveform with Marker Filter = 1\n\n" );
	dsm202.triangle_chirp		= true;
	dsm202.marker_filter_count1	= 1;
	dsm202.arm					= true;
	Thread::Sleep( 8000 );
	dsm202.abort				= true;

	return 0;
}